# Should work for Ubuntu and Mint late LTS versions

# Install LAPP stack
sudo apt install apache2
sudo systemctl start apache2
sudo systemctl enable apache2
sudo apt install php libapache2-mod-php openssl php-imagick php-common php-curl php-gd php-imap php-intl php-json php-ldap php-mbstring php-pgsql php-ssh2 php-xml php-zip unzip
sudo apt install postgresql

# Install required libraries
sudo apt install libpqxx-6.4
sudo apt install libpqxx-dev

# Create Postgres user and database.  User will need password change.
# Create Postgres user and database.  User will need password change.
sudo -i -u postgres createdb datafile
sudo -i -u postgres createuser -s -P pcl
echo ""
echo "enter the following in psql - "
echo "grant all privileges on database datafile to pcl;"
echo "\q to exit"
sudo -i -u postgres psql


# Untar the Datafile system
tar -zxvf datafile.tgz

# Copy and enable the datafile configuration.
sudo cp apache/datafile.sys.conf /etc/apache2/sites-available/
sudo a2ensite datafile.sys.conf
sudo mkdir /var/log/apache2/datafile

# Copy and enable the phppgadmin configu to Apache
sudo cp apache/phppgadmin.conf /etc/apache2/conf-available/
sudo a2enconf phppgadmin.conf

# Required for datafile.  It's disabled by defaut on Mint/Ubu
sudo a2enmod rewrite

#Copy the datafile web site
sudo cp -r datafile.sys/ /var/www/
sudo ln -s /home/datafile/pcldat /var/www/datafile.sys/pcldat
sudo ln -s /tmp /var/www/datafile.sys/print

#Copy the phppgadmin progs
sudo cp -r phppgadmin /usr/share/
 
sudo systemctl restart apache2

#Make link so php/javascript progs can access configuration info
echo "export PATH=$PATH:/home/datafile/bin/" >> .bashrc
echo "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/datafile/lib/" >> .bashrc

# Need this if any compilation necessary
sudo cp -r include/* /usr/include/

# Change the security settings on postgres.  Needs modifying if system is to be accessed
# from off site.  This is NOT secure.
# Note that 14 was the default postgres version at the time of writing.
# This may need to be modified for earlier/later versions of Mint/Ubu
sudo cp /etc/postgresql/14/main/pg_hba.conf /etc/postgresql/14/main/pg_hba.conf.bak
sudo cp postgres/pg_hba.conf /etc/postgresql/14/main/
sudo chown postgres:postgres /etc/postgresql/14/main/pg_hba.conf
sudo systemctl restart postgresql

# Make necessary postgres indices
cd installdb
sudo sh pcldoitall.sh
cd ..

# Activate system in hosts
sudo echo "127.0.0.1    www.datafile.sys" | sudo tee -a /etc/hosts

# Create ramdisk
sudo mkdir /mnt/ramdisk
sudo echo "asbo /mnt/ramdisk tmpfs size=500m,mode=0777,uid=datafile,gid=datafile 0 0" | sudo tee -a /etc/fstab
sudo mount -a

# Change some rights
sudo chmod 777 /var/www/datafile.sys/public_html/print
cd pcldat
sudo chmod 755 ..
cd ..


echo ""
echo "You should now consult the documentation before attempting to use"
echo "the system!!!!"




