<?php
    header('Content-type: application/json');
 
  
    require_once ("../cgi-bin/genutils.php");
    require('fpdf/fpdf.php');
  
    class PDF extends FPDF 
    {
        // Function to set the document header
        function Header() 
        {
/*            
            global $title;

            // Sets font to Arial bold 15
            $this->SetFont('Courier', 'B', 10);

            // Calculate string length 
            $w = $this->GetStringWidth($title) + 6;
            $this->SetX((210 - $w) / 2);

            // Set drawing color
            $this->SetDrawColor(0, 80, 180);

            // It defines the grey color for filling
            $this->SetFillColor(105, 105, 105);

            // Sets the text color
            $this->SetTextColor(255, 0, 0);

            // Set the line width to 1 mm)
            $this->SetLineWidth(1);

            // Prints a cell Title
            $this->Cell($w, 9, $title, 1, 1, 'C', 1);

            // Line break
            $this->Ln(10);
 
 */
        }

        function stringToPDF ($txt, $font, $fontSize) 
        {
            global $Parms ;
            
            $this -> AddPage () ;
            $this->SetFont($font, '', $fontSize);

            // It prints texts with line breaks
            $this->MultiCell(0, 5, $txt);

            //Puts a Line break
            $this->Ln();

        }
    }
    
    $Debug = true ;
    $Parms = GetParms();
    $searchFound = false ;
    
  $option = $Parms ['option'];
//    $option = 3 ;
/*    
    $option = 1 ;
    $startDate = "2023-03-03" ;
    $endDate = "2023-03-03" ;
    $ref = "P46" ;
*/

  
    function getFont ($report)#
    {
        global $Parms ;
        
        $systemId = $Parms ['systemId'] ;
        
        $jsonString = file_get_contents ("/home/datafile/pcldat/" . $systemId .".json") ;
        $jsonData = json_decode ($jsonString, true) ;
        $font = $jsonData ['printing'] [0] [$report] [0] ['font'] ;  
        if ($font === null)
        {    
            $font = $jsonData ['printing'] [0] ["default"] [0] ['font'] ;  
        }
        return ($font) ;
    }

    function getFontSize ($report)
    {
        global $Parms ;
        
        $systemId = $Parms ['systemId'] ;
        
        $jsonString = file_get_contents ("/home/datafile/pcldat/" . $systemId .".json") ;
        $jsonData = json_decode ($jsonString, true) ;
        $size = $jsonData ['printing'] [0] [$report] [0] ['size'] ;       
        if ($size === null)
        {
            $size = $jsonData ['printing'] [0] ['default'] [0] ['size'] ;       
        }
        return ($size) ;
    }
    
    function getOrientation ($report)
    {
        global $Parms ;
        
        $systemId = $Parms ['systemId'] ;
        
        $jsonString = file_get_contents ("/home/datafile/pcldat/" . $systemId .".json") ;
        $jsonData = json_decode ($jsonString, true) ;
        $size = $jsonData ['printing'] [0] [$report] [0] ['orientation'] ;       
        if ($size === null)
        {
            $size = $jsonData ['printing'] [0] ['default'] [0] ['orientation'] ;       
        }
        return ($size) ;
    }

    function getPaperSize ($report)
    {
        global $Parms ;
        
        $systemId = $Parms ['systemId'] ;
        
        $jsonString = file_get_contents ("/home/datafile/pcldat/" . $systemId .".json") ;
        $jsonData = json_decode ($jsonString, true) ;
        $size = $jsonData ['printing'] [0] [$report] [0] ['paperSize'] ;       
        if ($size === null)
        {
            $size = $jsonData ['printing'] [0] ['default'] [0] ['paperSize'] ;       
        }
        return ($size) ;
    }

    function openDb ()
    {
        global $db ;
        try 
        {
            $securityInfo = file_get_contents ("../pcldat/secfile.json") ;

            $dbInfo = json_decode ($securityInfo, true) ;
    //        $db = new PDO ('pgsql:host=localhost;dbname=ofea', 'pcl', 'parrot') ;

            $connStrg = 'pgsql:host=' .$dbInfo ["database"]["host"] .';' ;
            $connStrg .= 'dbname=' .$dbInfo ["database"]["dbName"] .';' ;
            $connStrg .= 'port=' . $dbInfo ["database"]["port"] . ';' ;
            $connStrg .= 'user=' . $dbInfo ["database"]["userName"] . ';' ;
            $connStrg .= 'password=' . $dbInfo ["database"]["password"]  ;
            $db = new PDO ($connStrg) ;
            $db -> setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);    
            MonitorF ("db opened") ;
    //        Monitor ("db opened") ;
        } 
        catch (Exception $ex)
        {
            $strg = $ex -> getMessage () ;
            echo ($strg) ;
            MonitorF ("Database error: " . $strg) ;
            exit (-1) ;
        }
    }    
    
    function Monitor($Strg)
    {
        global $Debug;
        if ($Debug)
            echo ($Strg . "<br>\n");
    }

    function MonitorF ($Strg)
    {
        global $Debug;
        
        if ($Debug)
        {
            $Fname = "/mnt/ramdisk/monitor.log" ;
            $OFile = fopen($Fname, "a+") 
                    or die ("Unable to opfen $Fname") ;
            fwrite($OFile, $Strg . "\n");
            fclose($OFile);
        }
    }

    function toArray ($strg)
    {
        $strg = trim ($strg, '{}') ;
        return (explode (',', $strg)) ;
    }
    
    function GetResults () 
    {
        global $db ;
        global $Parms ;
        $pageArray = array() ;

        $ref = $Parms ['refs'] ;
        $startDate = $Parms ['startDate'] ;
        $endDate = $Parms ['endDate'] ;
/*        
        $ref = 'P10SUR' ;
        $startDate = '2023-03-04' ;
        $endDate = '2023-03-04' ;
 */
 

        openDb () ;
        
        $arr = array () ;

        MonitorF ("ref " . $ref) ;
        $like = "'%" . $ref . "%'" ;
        $sql = "select indexid, indexdate, refs , pages,volume,fileno,ofst,lastofst,reclen,fastpages, fastpagesofst from df_mainindex where refs[1] LIKE " ;
        $sql .= $like ;
        $sql .= " AND indexdate >= '" . $startDate . "'"  ;
        $sql .= " AND indexdate <= '" . $endDate . "'" ;
        $sql .= ' ORDER BY indexid'  ;
        try
        {
            $rows = $db -> query ($sql) ;
        } 
        catch (Exception $ex)
        {
            $msg = $ex -> getMessage () ;
            echo ("Database error: " . $msg) ;
            monitorF ("Database error: ", $msg) ;
            exit (-1) ;
        }

        foreach ($rows as $res)
        {
            
            $temp = array ( "indexid" => $res ["indexid"],
                            "indexdate" => $res ["indexdate"],
                            "refs" => $res ["refs"],
                            "pages" => $res ["pages"],
                            "volume" => $res ["volume"],
                            "fileno" => $res ["fileno"],
                            "ofst" => $res ["ofst"],
                            "lastofst" => $res ["lastofst"],
                            "reclen" => $res ["reclen"],
                            "fastpages" => $res ["fastpages"],
/*
                            $tmpPage 
                            $pageArray = toArray ($res ["fastpagesofst"]) ;
 
 */
                            "fastpagesofst" => $res ["fastpagesofst"]
//                            "fastpagesofst" => toArray ($res ["fastpagesofst"]) ;
            );
            
            array_push ($arr, $temp) ;
        }

        $ret = json_encode ($arr) ;
        echo ($ret) ;
        exit (0) ;
    }    
        

    function getPage ($ss = '')
    {
        global $Parms ;
        $arr = array () ;
        $outputLineNo = 0 ;

        $fileNo = $Parms ['fileNo'] ;
        $ofst = $Parms ['ofst'] ;
        $lastOfst = $Parms ['lastOfst'] ;
        $systemId = $Parms ['systemId'] ;
        $music = ($Parms ['music'] === 'true') ;
        $searchFound = false ;
        
/*        
        $fileNo = 35008 ;
        $ofst = 3635688 ;
        $lastOfst = $ofst ;
        $sysId = "kap" ;
*/
        $iFName = "../pcldat/" . $systemId . ".json" ;
        $sysInfoFile = file_get_contents ($iFName) ;
        $sysInfo  = json_decode ($sysInfoFile, true) ;
        $recLen = $sysInfo ["recLen"] ;
        $dataDir = $sysInfo ["dataDir"] ;
        $dataFName = $dataDir . "/" . $fileNo . ".dat" ;

        if ($lastOfst == $ofst)
        {
            $lastOfst += 10000 ;
        }
        $pageLen = $lastOfst - $ofst ; 

        
        $iFile = fopen ($dataFName, "r") ;
        monitorF ("dataFName: " . $dataFName) ;
        fseek ($iFile, $ofst) ;
        $dataEbcdic = fgets ($iFile, $pageLen) ;
        $data = iconv("IBM-1047","ISO8859-1", $dataEbcdic);

        $lineCount = 0 ;
        $blankLine = "" ;

        for ($i=0; $i < 132; $i++)
            $blankLine .= ' ' ;
        for ($i=0; $i < $pageLen; $i += $recLen)
        {
            $line = substr ($data, $i, $recLen) ; 
            $leader = substr ($line, 0, 3) ;
            if ($leader === '002' && $lineCount != 0)
            {
                break ;
            }    
            $leader = substr ($line, 0, 4) ;
            for ($j = 1; $j < intval ($leader); $j++)
            {
                if (($outputLineNo % 2) && $music)
                {    
//                    array_push ($arr, '<span class="resboxGreen">' .$blankLine . '</span></br>') ;
                    $arr ['lines'] [$lineCount] = '<span class="resboxGreen">' .$blankLine . '</span></br>' ;
                }
                else
                {
//                    array_push ($arr , '<span>' . $blankLine . '</span></br>') ;
                    $arr ['lines'] [$lineCount] = '<span>' . $blankLine . '</span></br>' ;
              }
              $lineCount++ ;
                $outputLineNo++ ;
            }        
            if (($outputLineNo % 2) && $music)
            {
                $line = '<span class="resboxGreen">' . substr ($line, 4) . '</span></br>' ;
            }
            else 
            {
                $line = '<span class="resboxWhite">' . substr ($line, 4) . '</span></br>' ;
                
            }
            if ($ss != "")
            {
                $foundOfst = 0 ;
                $ssLen = strlen ($ss) ;
                $beg = '<span style="background-color:#FFC0F8">' ;
                $end = '</span>' ;
                $pos = strpos ($line, $ss, $foundOfst) ;
                while ($pos !== false)
                {
//                    $strg = substr($line, 0, $pos+$ssLen)  . "</end>" . substr($line, $pos + $ssLen) ;
                    $searchFound = true ;
                    $strg = substr($line, 0, $pos) . $beg . $ss . $end . substr($line, $pos + $ssLen);
//                    $line = $strg ;
//                    $strg .= substr($line, $pos + $ssLen) ;
                    $foundOfst += $pos + strlen ($ss) + strlen ($beg) + strlen ($end) ;
                    $pos = strpos ($line, $ss, $foundOfst) ;
                    $line = $strg ;
                }    
            }
//            array_push ($arr , $line) ;
            $arr ['lines'] [$lineCount] = $line ;
            $lineCount++ ;
            $outputLineNo++ ;
        }
        $arr ['searchFound'] = $searchFound;
        fclose ($iFile) ;
        $ret = json_encode ($arr) ;
        return ($ret) ;
    }

    function savePage ($arr)
    {
        global $Parms ;
        global $pdf ;
        
        $ref = $Parms ['ref'] ;
        
        $strg = "" ;
        foreach ($arr as $line)
        {    
            $strg .= $line ;
        }
        
        $pdf -> stringToPDF ($strg, getFont ($ref), getFontSize($ref)) ;
    }
    
    function printPage ($ofst, $lastOfst)
    {
        global $Parms ;
        $arr = array () ;
        

        $fileNo = $Parms ['fileNo'] ;
        $systemId = $Parms ['systemId'] ;
        
        $iFName = "../pcldat/" . $systemId . ".json" ;
        $sysInfoFile = file_get_contents ($iFName) ;
        $sysInfo  = json_decode ($sysInfoFile, true) ;
        $recLen = $sysInfo ["recLen"] ;
        $dataDir = $sysInfo ["dataDir"] ;
        $dataFName = $dataDir . "/" . $fileNo . ".dat" ;

        if ($lastOfst == $ofst)
        {
            $lastOfst += 10000 ;
        }
        $pageLen = $lastOfst - $ofst ; 
        $nextPage = $ofst ;
        
        $iFile = fopen ($dataFName, "r") ;
        monitorF ("dataFName: " . $dataFName) ;
        fseek ($iFile, $ofst) ;
        $dataEbcdic = fgets ($iFile, $pageLen) ;
        $data = iconv("IBM-1047","ISO8859-1", $dataEbcdic);

        $lineCount = 0 ;
        

        for ($i=0; $i < $pageLen; $i += $recLen)
        {
            $line = substr ($data, $i, $recLen) ; 
            $leader = substr ($line, 0, 3) ;
            if ($leader === '002' && $lineCount != 0)
            {
                break ;
            }    
            $leader = substr ($line, 0, 4) ;
            for ($j = 1; $j < intval ($leader); $j++)
            {
                array_push ($arr, "\n") ;
            }        
            
            $line = substr ($line, 4) ;
            array_push ($arr, $line . "\n") ;
            $lineCount++ ;
            $nextPage += $recLen ;
        }
        fclose ($iFile) ;
        savePage ($arr) ;
        return ($nextPage) ;
    }
    
    function printPages ()
    {
        global $Parms ;
        global $pdf ;

        $userId = $Parms ['userId'] ;
        $ref = $Parms ['ref'] ;
        
        $pdf = new PDF (getOrientation ($ref), 'mm', getPaperSize ($ref)) ;
        
        $pagesToPrint = $Parms ['pagesToPrint'] ;
        $lastOfst = $ofst = $Parms ['ofst'] ;
        for ($i = 0; $i < $pagesToPrint; $i++)
        {
            $lastOfst = $ofst = printPage ($ofst, $lastOfst) ;
//            $pdf -> AddPage () ;
        }
        $pdfName = "print/" .$userId . '_' . $ref . ".pdf" ;
        $pdf -> Output ($pdfName, "F") ;
        $ret = json_encode ($pdfName) ;
        echo ($ret) ;
        exit (0);
    }
    
    function retrievePage ()
    {
        $ret = getPage () ;
        echo ($ret) ;
        exit (0) ;
    }
    
    function findPage ()
    {
        global $Parms ;
        global $searchFound ;
        
        $ss = $Parms ['ss'] ;

//        $ss = 'HEAD' ;
        $ret = getPage ($ss) ;
        echo ($ret) ;
        exit (0) ;
    }
    
    function returnSystems ()
    {
        
        $jsonString = file_get_contents ("/home/datafile/pcldat/dfsites.json") ;
        echo ($jsonString) ;
        exit (0) ;
    }    

    function returnPrefs ()
    {
        global $Parms ;
        global $db ;
        $arr = [] ;
        
        $userId = $Parms ['userId'] ;
        try
        {
            openDb () ;
            $sql = "select music FROM df_user_prefs where userid =  " ;
            $sql .= $userId ;
            $stmt = $db ->prepare ($sql) ;
            $stmt -> execute () ;
            $row = $stmt-> fetch () ;
        }
        catch (Exception $ex)
        {
            $msg = $ex -> getMessage () ;
            echo ("Database error: " . $msg) ;
            monitorF ("Database error: ", $msg) ;
            exit (-1) ;
        }
        
        if ($row != false)
        {
            $ret = json_encode ($row ['music']) ;
        }
        else 
        {
            $ret = json_encode (true) ;
        }
        echo ($ret) ;
        exit (0) ;
    }    
    
    function setPrefs ()
    {
        global $Parms ;
        global $db ;
        
        $userId = $Parms ['userId'] ;
        $music = $Parms ['music'] ;
        
        try
        {
            openDb () ;
            $sql = "UPDATE df_user_prefs SET music=? WHERE userid=?" ;
            $stmt = $db -> prepare ($sql) ;
            $stmt -> execute ([$music, $userId]) ;
            
        }
        catch (Exception $ex)
        {
            $msg = $ex -> getMessage () ;
            echo ("Database error: " . $msg) ;
            monitorF ("Database error: ", $msg) ;
            exit (-1) ;
        }
    }
    
    
    switch ($option)
    {
        case 1:
            GetResults();
            break;
        case 2:
            retrievePage () ;
            break;
        case 3:
            findPage () ;
        case 4:
            printPages () ;
        case 5:
            returnSystems () ;
        case 6:
            returnPrefs () ;
        case 7:
            setPrefs () ;
    }    
    
    
?>
