#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>

using namespace std ;


#include "../include/idxclass.h"
//#include "../include/ebcdic.h"

extern "C"
{
    tIndex::tIndex ()
    {
        idxOpen = false ;
        eof = false ;
        indexHeaderLen = sizeof (systemId) ;
        indexHeaderLen += sizeof (ver) ;
        indexHeaderLen += sizeof (noRefs) ;
        indexHeaderLen += sizeof (refLen) ;
        allocRefs () ;

    }

    tIndex::~tIndex ()
    {
        if (idxOpen)
            idxFile.close () ;
        freeRefs () ;
    }

    void tIndex::allocRefs ()
    {
        refs = (char**) calloc (5, sizeof (char*)) ;
        for (auto i = 0 ; i < 5 ; i ++)
        {
            refs [i] = (char*) calloc (31, sizeof (char)) ;
        }
    }

    void tIndex::freeRefs ()
    {
        if (refs != NULL)
        {
            for (auto i = 0 ; i < 5 ; i ++)
            {
                free (refs [i]) ;
                refs [i] = NULL ;
            }
            free (refs) ;
            refs = NULL ;
        }
    }

    void tIndex::openIndexFile (string fileName)
    {
        idxFile.open (fileName, ios::binary | ios::in | ios::out) ;
        idxOpen = idxFile.is_open() ;
        if (!idxOpen)
        {
            throw ("Failed to open: " + fileName) ;
        }
    }

    void tIndex::readHeader ()
    {
        idxFile.read (&systemId, sizeof (systemId)) ;
        idxFile.read ((char*) &ver, sizeof (ver)) ;
        idxFile.read ((char*) &noRefs, sizeof (noRefs)) ;
        idxFile.read ((char*) &refLen, sizeof (refLen)) ;
    }

    void tIndex::readIndexRecord ()
    {
        idxFile.read ((char*)  &pages, sizeof (pages)) ;
        idxFile.read ((char*)  &volume, sizeof (volume)) ;
        idxFile.read ((char*)  &file, sizeof (file)) ;
        idxFile.read ((char*)  &ofst, sizeof (ofst)) ;
        idxFile.read ((char*)  &lastOfst, sizeof (lastOfst)) ;
        idxFile.read ((char*)  &recLen, sizeof (recLen)) ;
        for (auto i = 0; i < noRefs; i++)
        {
            idxFile.read (refs [i], refLen) ;
        }
        idxFile.read (noteString, 15) ;
        idxFile.read ((char*) &printed, sizeof (printed)) ;
        idxFile.read ((char*)  &pageFileName, 7) ;
        idxFile.read ((char*)  &spare, 14) ;
        eof = (idxFile.peek () == EOF) ;

    }

    void tIndex::printIndexRecord ()
    {
        char* ostrg = new char [256] ;
        int i ;

        for (i = 0 ; i < noRefs -1; i ++)
        {
            sprintf (ostrg, "\n%-30.30s", refs [i]);
            cout << ostrg ;
        }
        sprintf (ostrg, "%-30.30s%6u%6d%6d%10u%10u%8d%8d%20s",
                 refs [i],
                 pages,
                 volume,
                 file,
                 ofst,
                 lastOfst,
                 recLen,
                 printed,
                 pageFileName) ;
        cout << ostrg << endl ;
        delete ostrg ;
    }

    void tIndex::dumpIndex ()
    {
        char* ostrg = new char [256] ;

        cout << "systemId: " << systemId << " ver: " << ver << " noRefs: " << noRefs << " reflen: " << refLen << endl ;
        sprintf (ostrg, "Reference                      Pages  Vol.  File      Ofst      Last     Len.   Printed  Page File Name\n\n") ;
        cout << ostrg ;
//        while (!idxFile.eof ())
        while (idxFile.peek () != EOF)
        {
            readIndexRecord () ;
            printIndexRecord () ;
        }
        delete ostrg ;
    }

    bool tIndex::isEof ()
    {
        return (eof) ;
    }

    vector <string> tIndex::getRefs ()
    {
        vector <string> ret ;
        for (auto i = 0; i < noRefs; i++)
        {
            ret.push_back (refs [i]) ;
        }
        return (ret) ;
    }

    int tIndex::getPages ()
    {
        return (pages) ;
    }

    int tIndex::getFileNo ()
    {
        return (file) ;
    }

    int tIndex::getVolume ()
    {
        return volume ;
    }

    int tIndex::getOfst ()
    {
        return ofst ;
    }

    int tIndex::getLastOfst ()
    {
        return lastOfst ;
    }

    int tIndex::getRecLen ()
    {
        return recLen ;
    }

    string tIndex::getPageFileName ()
    {
        return (string (pageFileName)) ;
    }

    void tIndex::setRefs (vector <string> refs)
    {

    }

    void tIndex::setPages (int paramPages)
    {
        pages = paramPages ;
    }

    void tIndex::setVolume (int paramVolume)
    {
        volume = paramVolume ;
    }

    void tIndex::setFileNo (int paramFileNo)
    {
        file = paramFileNo ;
    }

    void tIndex::setOfst (int paramOfst)
    {
        ofst = paramOfst ;
    }

    void tIndex::setLastOfst (int paramLastOfst)
    {
        lastOfst = paramLastOfst ;
    }

    void tIndex::setRecLen (int paramRecLen)
    {
        recLen = paramRecLen ;
    }



}
