#include <iostream>
#include <fstream>
#include <vector>

using namespace std;

#include <idxclass.h>
#include <pcldb.h>
#include <dirent.h>

vector <string> getMonths (string indexDir)
{
    DIR* dir ;
    struct dirent* ent ;
    vector <string> ret ;
    string name ;
    bool useIt = true ;

    if ((dir = opendir (indexDir.c_str())) != NULL)
    {
        while ((ent = readdir (dir)) != NULL)
        {
            name = (string) ent -> d_name ;
            useIt = (name [0] != '.') ;
            if (useIt)
            {
                try
                {
                    ret.push_back (name) ;
                }
                catch (...)
                {
                    useIt = false ;
                }
                useIt = false ;
            }
        }
        closedir (dir);
    }
    return (ret) ;

}

vector <string> getIdxFiles (string month)
{
    DIR* dir ;
    struct dirent* ent ;
    vector <string> ret ;
    string name ;
    bool useIt = true ;

    if ((dir = opendir (month.c_str())) != NULL)
    {
        while ((ent = readdir (dir)) != NULL)
        {
            name = (string) ent -> d_name ;
            useIt = (name [0] != '.' && (name.find (".idx") != string::npos) && (name.length () == 6)) ;
            if (useIt)
            {
                try
                {
                    ret.push_back (name) ;
                }
                catch (...)
                {
                    useIt = false ;
                }
                useIt = false ;
            }
        }
        closedir (dir);
    }
    return (ret) ;

}

string buildRefStrg (vector <string> refs)
{
    string ret = "ARRAY " ;
    int i = 0 ;

    for (auto ref = refs.begin(); ref != refs.end (); ++ ref)
    {
        if (i > 0)
            ret += "," ;
        ret += "['" + *ref + "']" ;
        i++ ;
    }
    return ret ;
}

string buildPageArray (string pageFileName, string currDate, string indexDir)
{
    string ret = "" ;
    string iFileName ;
    fstream iFile ;
    vector <int> pageOfsts ;
    int ofst ;
    int i = 0 ;

    if (pageFileName != "")
    {
        currDate.insert (6, "/") ;
        iFileName = indexDir + "/" +currDate + "/" + pageFileName ;
        iFile.open (iFileName, ios::binary|ios::in) ;
        if (iFile.is_open())
        {
            while (iFile.peek () != EOF)
            {
                iFile.read ((char*) &ofst, sizeof (ofst)) ;
                pageOfsts.push_back (ofst) ;
            }
            ret = ", 'TRUE', ARRAY[" ;
            for (auto page = pageOfsts.begin (); page < pageOfsts.end (); ++page)
            {
                if (i > 0)
                    ret += "," ;
                ret += to_string (*page) ;

                i++ ;
            }
            ret += "]" ;
            iFile.close () ;
        }
        else
            throw ("Unable to open: " + iFileName) ;
        cout << "\t\tpageFileName: " << pageFileName << endl ;
    }
    return ret ;
}

int main (int argc, char** argv)
{
    vector <string> months ;
    vector <string> idxFiles ;
    vector <string> refs ;
    tIndex* ptIndex ;
    int pages ;
    int volume ;
    int fileNo ;
    int ofst ;
    int lastOfst ;
    int recLen ;
    string sql ;
    TDatabase* pTDatabase ;
    string systemId ;
    string currDate ;
    string day ;
    string refStrg ;
    string pageFileName ;
    string pageArray ;

    if (argc != 3)
    {
        cout << "Usage: idxconv <system e.g. MIS> <Index Direcory>" << endl ;
        exit (-1) ;
    }
    try
    {
        pTDatabase = new TDatabase ("/home/datafile/pcldat/secfile") ;
    }
    catch (string error)
    {
        cout << error << endl ;
        exit (-1) ;
    }
    systemId = string (argv [1]) ;
    months = getMonths ((string (argv [2]))) ;
    for (auto month = months.begin(); month != months.end(); ++month)
    {
        cout << "month: " << *month << endl ;
        idxFiles = getIdxFiles (string (argv [2]) + "/" + *month) ;
        for (auto idx = idxFiles.begin(); idx != idxFiles.end(); ++idx)
        {
            cout << "\tidx: " << *idx << endl ;
            try
            {
                ptIndex = new tIndex () ;
                ptIndex -> openIndexFile (string (argv [2]) + "/" + *month + "/" + *idx) ;
                ptIndex -> readHeader () ;
                currDate = *month ;
                day = *idx ;
                currDate += day.substr (0,2) ;
                sql = "INSERT INTO df_mainindex_def (systemid, indexdate) VALUES (" ;
                sql += "'" + systemId + "'," ;
                sql += "'" + currDate + "') ;" ;
                cout << sql << endl ;
                pTDatabase -> ExecSql (sql) ;

                while (!ptIndex -> isEof ())
                {
                    ptIndex -> readIndexRecord ();
                    refs = ptIndex -> getRefs () ;
                    pages = ptIndex -> getPages () ;
                    volume = ptIndex -> getVolume () ;
                    fileNo = ptIndex -> getFileNo () ;
                    ofst = ptIndex -> getOfst () ;
                    lastOfst = ptIndex -> getLastOfst () ;
                    recLen = ptIndex -> getRecLen () ;
                    pageFileName = ptIndex -> getPageFileName () ;
                    pageArray = buildPageArray (pageFileName, currDate, string (argv [2])) ;

                    for (auto ref = refs.begin(); ref != refs.end (); ++ ref)
                        cout << "\t\tref: " << *ref << endl ;
                    sql = "INSERT INTO df_mainindex " ;
                    sql += "(indexdate, pages, volume, fileno, ofst, lastofst, reclen, refs" ;
                    if (pageArray != "")
                        sql += ", fastpages, fastpagesofst" ;
                    sql += ") VALUES " ;
                    sql += "(" ;
                    sql += "'" + currDate + "'," ;
                    sql += to_string (pages) + "," ;
                    sql += to_string (volume) + "," ;
                    sql += to_string (fileNo) + "," ;
                    sql += to_string (ofst) + "," ;
                    sql += to_string (lastOfst) + "," ;
                    sql += to_string (recLen) + "," ;
                    refStrg = buildRefStrg (refs) ;
                    sql += refStrg ;
                    if (pageArray != "")
                        sql += pageArray ;
                    sql += ") ;" ;

                    cout << sql << endl ;
                    pTDatabase -> ExecSql (sql) ;
                }
                delete ptIndex ;
            }
            catch (string Err)
            {
                cout << Err << endl ;
                exit (-1) ;
            }

        }
    }
    delete pTDatabase ;
    exit (0) ;
}

