#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>

using namespace std ;

#include "../include/idxclass.h"

/*
class tIndex
{
public:
    tIndex () ;
    ~tIndex () ;

    void openIndexFile (string fileName) ;
    void dumpIndex () ;
    void readHeader () ;
    void readIndexRecord () ;
    void printIndexRecord () ;
private:
    void allocRefs () ;
    void freeRefs () ;

    unsigned short int pages ;
    short int volume ;
    short int file ;

//    unsigned long ofst ;
//   unsigned long lastOfst ;

    unsigned int ofst ;
    unsigned int lastOfst ;
    short int recLen ;
    char noteString [16] ;
    char** refs ;
    char systemId ;
    float ver ;
    short int noRefs ;
    short int refLen ;
    char pageFileName [7] ;
    char spare [14] ;
    short int printed ;
    int indexHeaderLen ;
    fstream idxFile ;
    bool idxOpen ;

} ;

tIndex::tIndex ()
{
    idxOpen = false ;
    indexHeaderLen = sizeof (systemId) ;
    indexHeaderLen += sizeof (ver) ;
    indexHeaderLen += sizeof (noRefs) ;
    indexHeaderLen += sizeof (refLen) ;
    allocRefs () ;

}

tIndex::~tIndex ()
{
    if (idxOpen)
        idxFile.close () ;
    freeRefs () ;
}

void tIndex::allocRefs ()
{
    refs = (char**) calloc (5, sizeof (char*)) ;
    for (auto i = 0 ; i < 5 ; i ++)
	{
        refs [i] = (char*) calloc (31, sizeof (char)) ;
	}
}

void tIndex::freeRefs ()
{
	if (refs != NULL)
	{
        for (auto i = 0 ; i < 5 ; i ++)
		{
			free (refs [i]) ;
			refs [i] = NULL ;
		}
		free (refs) ;
		refs = NULL ;
	}
}

void tIndex::openIndexFile (string fileName)
{
    idxFile.open (fileName, ios::binary | ios::in | ios::out) ;
    idxOpen = idxFile.is_open() ;
    if (!idxOpen)
    {
        throw ("Failed to open: " + fileName) ;
    }
}

void tIndex::readHeader ()
{
    idxFile.read (&systemId, sizeof (systemId)) ;
    idxFile.read ((char*) &ver, sizeof (ver)) ;
    idxFile.read ((char*) &noRefs, sizeof (noRefs)) ;
    idxFile.read ((char*) &refLen, sizeof (refLen)) ;
}

void tIndex::readIndexRecord ()
{
    idxFile.read ((char*)  &pages, sizeof (pages)) ;
    idxFile.read ((char*)  &volume, sizeof (volume)) ;
    idxFile.read ((char*)  &file, sizeof (file)) ;
    idxFile.read ((char*)  &ofst, sizeof (ofst)) ;
    idxFile.read ((char*)  &lastOfst, sizeof (lastOfst)) ;
    idxFile.read ((char*)  &recLen, sizeof (recLen)) ;
    for (auto i = 0; i < noRefs; i++)
    {
        idxFile.read (refs [i], refLen) ;
    }
    idxFile.read (noteString, 15) ;
    idxFile.read ((char*) &printed, sizeof (printed)) ;
    idxFile.read ((char*)  &pageFileName, 7) ;
    idxFile.read ((char*)  &spare, 14) ;
}

void tIndex::printIndexRecord ()
{
    char* ostrg = new char [256] ;
    int i ;

    for (i = 0 ; i < noRefs -1; i ++)
	{
		sprintf (ostrg, "\n%-30.30s", refs [i]);
		cout << ostrg ;
	}
    sprintf (ostrg, "%-30.30s%6u%6d%6d%10u%10u%8d%8d%20s",
             refs [i],
             pages,
             volume,
			 file,
			 ofst,
			 lastOfst,
			 recLen,
             printed,
             pageFileName) ;
	cout << ostrg << endl ;
    delete ostrg ;
}

void tIndex::dumpIndex ()
{
    char* ostrg = new char [256] ;

    cout << "systemId: " << systemId << " ver: " << ver << " noRefs: " << noRefs << " reflen: " << refLen << endl ;
    sprintf (ostrg, "Reference                      Pages  Vol.  File      Ofst      Last     Len.   Printed  Page File Name\n\n") ;
    cout << ostrg ;
    while (!idxFile.eof ())
    {
        readIndexRecord () ;
        printIndexRecord () ;
    }
    delete ostrg ;
}

*/

int main (int argc, char** argv)
{
    tIndex* ptIndex ;
    string FileName ;

    if (argc != 2)
    {
        cout << "Usage: idxdump <filename>" << endl ;
        exit (-1) ;
    }
    FileName = string (argv [1]) ;
    ptIndex = new tIndex () ;

    try
    {
        ptIndex -> openIndexFile (FileName) ;
        ptIndex -> readHeader () ;
        ptIndex -> dumpIndex () ;
    }
    catch (string Err)
    {
        cout << Err << endl ;
        exit (-1) ;
    }
    delete ptIndex ;
    return (0) ;
}
