#ifdef __DLL__
    #define CBEXPORT _export
#else
    #define CBEXPORT _export
#endif

#ifndef PAGING_H

#define PAGING_H


/*
    TFLines Rubbish added 17/10/94 C.B.

    ver 2.36
*/
#ifndef ESCAPE
    #include "escape.h"
#endif

#ifndef DATAFILE_H
	#include "datafile.h"
#endif


#ifndef INDEXSET_H
	#include "indexset.h"
#endif

class TFLinesBase
{
public:
	TFLinesBase (char* PReport, int PLines) ;
	~TFLinesBase () ;
	char* Report ;
	int Lines ;
	TFLinesBase* Next ;
} ;

class TFLines
{
public:
	TFLines (char* FilePath) ;
	~TFLines () ;
	int ReturnLines (char* Report) ;
	int ListBuilt () ;
private:
	void BuildList (char* FilePath) ;
	void KillList () ;
	TFLinesBase* Base ;
	TFLinesBase* Next ;
	TFLinesBase* Curr ;
	int ListOk ;
	int Default ;
} ;

class CBEXPORT THeaderRec
{
public:
	THeaderRec (int PLineNo, char* PHeader) ;
	~THeaderRec () ;
	int LineNo ;
	char* Header ;
	THeaderRec* Next ;
} ;

#ifndef WIN32
class CBEXPORT THeader
{
public:
    THeader (char* PRef, char* Date, char* SystemSettingsPath) ;
    ~THeader () ;
    char* ReturnHeader (int LineNo) ;

private:
    void BuildList (char* PRef, char* Date, char* SystemSettingsPath) ;
    void KillList () ;
	THeaderRec* Base ;
	THeaderRec* Curr ;
	THeaderRec* Next ;
} ;
#else
class CBEXPORT TPCLHeader
{
public:
    TPCLHeader (char* PRef, char* Date, char* SystemSettingsPath) ;
    ~TPCLHeader () ;
    char* ReturnHeader (int LineNo) ;

private:
    void BuildList (char* PRef, char* Date, char* SystemSettingsPath) ;
    void KillList () ;
	THeaderRec* Base ;
	THeaderRec* Curr ;
	THeaderRec* Next ;
} ;
#endif

class TDelCharBase
{
public:
    TDelCharBase (char* Strg) ;
    ~TDelCharBase () ;
    char* DelString ;
    TDelCharBase* Next ;
} ;

class TDelChars
{
public:
    TDelChars (char* SystemSettingsPath) ;
    ~TDelChars () ;
    void DeleteChars (char* Strg) ;
private:
    void BuildList (char* Path) ;
    void KillList () ;
    TDelCharBase* Base ;
    TDelCharBase* Next ;
    TDelCharBase* Curr ;
} ;
class CBEXPORT TPaging
{
public:
	TPaging (TIndex*) ;
	TPaging (TIndex* PIndex, char* Dest, char* ReportName) ;
	~TPaging () ;
	int NewPage (char* buf) ;
	unsigned long PageToScreenBuf (TCBFile* DataFile, unsigned long Ofst, BOOL DoEsc = 1) ;
	unsigned long PageUp (TCBFile* PDataFile, unsigned long Ofst, BOOL DoEsc = TRUE) ;
	unsigned long PageToExportFile (TCBFile* PDataFile, TCBFile* Ofile, unsigned long Ofst) ;
	int IsControlNewPage (char* Srch) ;
	int CheckFromControlFile (char* buf) ;

	int LinesThisPage ;
	IndexTypeSettings*  PIndexSet ;
	int LeaderLength ;
	int PageSeparator ;
	int MaxLinesOnPage ;
	int RecordLength ;
	char** ScreenBuf ;
	int MaxLineLength ;

private:
	int CheckNewAscii (char* buf) ;
	int CheckNew10 (char* buf) ;
	int CheckNew1 (char* buf) ;
	int CheckNew4 (char* buf) ;
	void AllocScreenBuf () ;
	void ClearScreenBuf () ;
    int CheckPageHeader (char* Buf) ;
    void CheckPHeader () ;
	void AdjustAscii (TCBFile* PDataFile, char* Buf, unsigned long* CurrentOfst) ;
	void LoseZeros (char* Buf) ;
	void InsertHeaders () ;
	void InsertEsc () ;
	void PagingSetup (TIndex* PIndex, char* ReportName = NULL) ;

    int Header1 ;
    int Header2 ;
    int Header3 ;
    int Header4 ;
    char Head1Char ;
    char Head2Char ;
    char Head3Char ;
    char Head4Char ;
    BOOL PageHeader ;
#ifndef WIN32
    THeader* PHeader ;
#else
    TPCLHeader* PHeader ;
#endif
    TEsc* PEscSource ;
	TEsc* PEscDest ;
	char* Dest ;
	TDates* IndexDate ;
	unsigned long LastOfst ;
	TIndex* PLIndex ;
	/*
		Added 11/10/94 for Criterion type Data

		CB ver 2.36
	*/
    TFLines* PFLines ;
	/*
		New function added C.B. 17/10/94

		ver 2.36
	*/

    BOOL CriterionNewPage (int LinesThisPage) ;
	/*
		Added C.B. 17/10/94 for Criterion Data

		C.B. ver 2.36
	*/
	char* LocalReportName ;
	char* SystemSettingsPath ;
	char* ParametersPath ;
	char* HomePath ;
	char* SystemId ;
    TDelChars* PDelChars ;
} ;


typedef struct SbRec
{
	char* Buf ;
	int LineNo ;
	SbRec* Next ;
} SbRec ;

#ifndef WIN32
extern "C"  unsigned long pascal _export PageToDisk (TIndex* PIndex, TDataFile* PDataFile, unsigned long OffsetToRead) ;
#else
extern "C"  unsigned long pascal _export PageToDisk (TIndex* PIndex, TDataFile* PDataFile, unsigned long OffsetToRead, char* SystemId) ;
#endif

extern "C"  long pascal _export PageSearch (TIndex* PIndex, TDataFile* PDataFile, long OffsetToRead, char* SS, BOOL MatchCase, long* LastOfst, long* CurPage, long Pages, BOOL* Found) ;

extern "C" unsigned long pascal _export DoPageUp (TIndex* PIndex, TDataFile* PDataFile, unsigned long CurOfst) ;
extern "C" unsigned long pascal _export CPageToScreenBuf (TIndex* PIndex, TDataFile* PDataFile, unsigned long OffsetToRead, SbRec* Base, int* LinesThisPage) ;
extern "C" unsigned long pascal _export PageToExportFile (TIndex* PIndex, TCBFile* PDataFile, char* OFileName, unsigned long Ofst) ;

#ifdef WIN32
    extern TPaging* __fastcall _export MakePaging (TIndex* PIndex) ;
    extern void __fastcall _export KillPaging (TPaging* PPaging) ;

#endif
#endif
