#ifndef PCLDB_H_INCLUDED
#define PCLDB_H_INCLUDED






// ***********************************************  Comment next line if running on willyshit *********************************

/*************************************************************************************************************************
Why must I comment out the SANE definition if I'm running on M$?

Here is a direct quote from the site maintaining the postgresql c++ api -

"Then there's Microsoft Windows. This platform is supported, but it's a bit more difficult because of its lack of
package management, software distribution infrastructure, standardized development environment,
filesystem layout standards and so on. The easiest way to build and use libpqxx on a Windows system is to install
a port of the  GNU toolset such as  MSYS, and proceed as you were using a Unix variant.
Alternatively, libpqxx comes with pre-built configuration headers and Makefiles for use with Visual C++. See
win32/INSTALL.txt for instructions. "

Quite frankly I can't be arsed to fool around on M$ systems and I'm certainly not prepared to source a copy
of Visual C++.

sqlite should be more than adequate for anything that an M$ platform could support anyway ;)

****************************************************************************************************************************/


#define SANE

#include <iostream>
#include <fstream>
#include <sstream>
#include <string.h>
#include <vector>
#include <cstdlib>
#include <stdio.h>
#include <stdlib.h>
#ifdef SANE
	#include <pqxx/pqxx>
#endif
#include <sqlite3.h>
//#include <boost/algorithm/string.hpp>

using namespace std;
#ifdef SANE
	using namespace pqxx ;
#endif

#define PGSQL 1
#define SQLITE 2
#define PGSQLPQ 3

void* pTShowRes ;

class TDbParms
{
	public:
		TDbParms (string SecFileName) ;
		~TDbParms () ;
		virtual string GetConnStrg () ;
		int GetDbTypeNo () ;
    private:
        string Host ;
        string DbName ;
        string User ;
        string Password ;
        string ConnStrg ;
        string DbType ;
		int DbTypeNo ;
} ;


class TDatabase
{
	public:
		TDatabase (string SecFileName) ;
		~TDatabase () ;
		void DoSql (string Sql) ;
		int GetTotalRows () ;
		int GetColumns () ;
		vector <std::string> GetRow ()	;
		string GetField (string Name) ;
		void ExecSql (string Sql) ;
		void Commit () ;
	private:
		void MakeCountSql (string Sql) ;
		void ShowRow () ;


		string ConnStrg ;
		TDbParms* pTDbParms ;
		int DbTypeNo ;
		char *ErrMsg ;
		int TotalRows ;
		string CountSql ;
		vector <std::string> ThisRow ;
		int ColsThisRow ;
#ifdef SANE
		// postgres specific
		bool NeedsCommit  ;
		connection* PgCon ;
		result PgRes ;
		work* PgSql ;
		result::const_iterator SqlRow ;
		int PgColumns ;
		int Columns ;
		int CurrentRow ;
#endif
		// sqlite3 specific

		sqlite3* LiteDb ;
		int LiteRc ;
		int LiteRes ;
		sqlite3_stmt* Statement ;
		vector <string> ColNames ;
} ;

#endif // PCLDB_H_INCLUDED

