#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>

#include <dirent.h>
#include <nlohmann/json.hpp>

using namespace std;

#include <ebcdic.h>
#include <pcldb.h>

TDatabase* pTDatabase ;
string indexDate ;
string sysName ;
string sql ;
int pages = 1 ;
int volume ;
string reportId ;
int fileNo ;
vector <int> offsets ;
long offset = 0 ;
long lastOffset = 0 ;
long firstOffset = 0 ;
int  lineLength ;
string ofstStrg ;
int ofstCnt ;
string lastRef = "" ;
string line ;
int srchStart ;
vector <string> srch ;
vector <int> jump ;
size_t pos ;
ifstream iFile ;

class config
{
    public:
        config (string systemName) ;
        string getValue (string value) ;
        int getIntValue (string value) ;
        vector <string> getStringVector(string value) ;
        vector <int> getIntVector(string value) ;
    private:
        nlohmann::json json ;
} ;

config::config (string systemName)
{
    string iFName = "/home/datafile/pcldat/" + systemName + ".json" ;
    ifstream iFile (iFName) ;
    stringstream buf ;

    cout << "iFName: " << iFName << endl ;
    buf << iFile.rdbuf() ;
    json = nlohmann::json::parse(buf.str());
}

string config::getValue (string value)
{
    return (json [value]) ;
}

int config::getIntValue (string value)
{
    string ret ;

    ret = json [value] ;
    return (stoi (ret)) ;
}

vector <string> config::getStringVector (string value)
{
    vector <string> ret ;
    for (auto  strg : json [value])
    {
        ret.push_back (strg) ;
    }
    return (ret) ;
}

vector <int> config::getIntVector (string value)
{
    vector <int> ret ;
    for (auto  i : json [value])
    {
        ret.push_back (i) ;
    }
    return (ret) ;
}

config* pconfig ;

const std::string WHITESPACE = " \n\r\t\f\v";

std::string ltrim(const std::string &s)
{
    size_t start = s.find_first_not_of(WHITESPACE);
    return (start == std::string::npos) ? "" : s.substr(start);
}

std::string rtrim(const std::string &s)
{
    size_t end = s.find_last_not_of(WHITESPACE);
    return (end == std::string::npos) ? "" : s.substr(0, end + 1);
}

std::string trim(const std::string &s) {
    return rtrim(ltrim(s));
}

int getLineLength (string fileName)
{
    size_t pos ;

    pos = fileName.rfind ('.') ;
    string ext = fileName.substr (pos+1) ;

    return (stoi (ext)) ;
}

vector <string> getIndexableFiles (string dataDir)
{
    DIR* dir ;
    struct dirent* ent ;
    vector <string> ret ;
    string name ;
    bool useIt = false ;
    size_t pos ;

    if ((dir = opendir (dataDir.c_str())) != NULL)
    {
        while ((ent = readdir (dir)) != NULL)
        {
            name = (string) ent -> d_name ;
            useIt = (name [0] != '.') ;
            if (useIt)
            {
                pos = name.rfind ('.') ;
                try
                {
                    string ext = name.substr (pos+1) ;
                    bool isNum = (ext.find_first_not_of( "0123456789" ) == std::string::npos);
                    useIt = (isNum) ;
                    if (useIt)
                    {
                        ret.push_back (name) ;

                    }
                }
                catch (...)
                {
                    useIt = false ;
                }
                useIt = false ;
            }
        }
        closedir (dir);
    }
    return (ret) ;
}

int getNextFileNo ()
{
    string iStrg ;
    fstream iFile ("/home/datafile/pcldat/nextfileno") ;

    getline (iFile, iStrg) ;
    return (stoi (iStrg)) ;
}

int getVolume ()
{
    string iStrg ;
    fstream iFile ("/home/datafile/pcldat/pcllab") ;

    getline (iFile, iStrg) ;
    return (stoi (iStrg)) ;
}

string buildRefStrg ()
{
    string ret = "ARRAY " ;

    ret += "['" + lastRef + "']" ;
    return ret ;
}

void doSql ()
{
    sql = "INSERT INTO df_mainindex " ;
    sql += "(indexdate, pages, volume, refs, fileno, ofst, lastofst, reclen, fastpages, fastpagesofst) " ;
    sql += "VALUES (" ;
    sql += "'" + indexDate + "'," ;
    sql += "'" + to_string (pages) + "',";
    sql += "'" + to_string (volume) + "',";
    sql +=  buildRefStrg () + "," ;
    sql += "'" + to_string (fileNo) + "'," ;
    sql += "'" + to_string (firstOffset) + "'," ;
    if (pages == 1)
        sql += "'" + to_string (firstOffset) + "'," ;
    else
        sql += "'" + to_string (lastOffset) + "'," ;
    sql += "'" + to_string (lineLength) + "'," ;
    sql += "'TRUE'," ;
    ofstCnt = 0 ;
    ofstStrg = "" ;
    for (auto pageOfst = offsets.begin (); pageOfst < offsets.end(); ++pageOfst)
    {
        if (ofstCnt > 0)
        {
            ofstStrg += "," ;
        }
        ofstStrg += to_string (*pageOfst) ;
        ofstCnt ++ ;
    }
    sql += "ARRAY [" + ofstStrg + "]" ;
    sql += ") ;" ;
//    cout << "sql: " << sql << endl ;
    pTDatabase -> ExecSql (sql) ;
}

bool CheckNextLine ()
{
    int currOfst ;
    bool found = false ;
    int j = 0 ;
    unsigned char* buf  = new unsigned char [lineLength+1];

    currOfst = iFile.tellg () ;
    iFile.read ((char*) buf, lineLength) ;
    toAscii (buf, lineLength) ;
    line = string ((char*) buf) ;

    for (auto i = srch.begin(); i != srch.end(); ++i)
    {
        if (!found)
        {
            pos = line.find (*i, srchStart) ;
            if (pos < lineLength)
            {
                reportId = line.substr (pos + jump [j]) ;
                found = true ;
            }
        }
        j++ ;
    }
    if (!found)
    {
        reportId = "DUFF" ;
    }
    iFile.seekg (currOfst) ;
    return found ;
}

void getReportId ()
{
    int currOfst ;
    bool found = false ;
    int j = 0 ;

    for (auto i = srch.begin(); i != srch.end(); ++i)
    {
        if (!found)
        {
            pos = line.find (*i, srchStart) ;
            if (pos < lineLength)
            {
                reportId = line.substr (pos + jump [j]) ;
                found = true ;
            }
        }
        j++ ;
    }
    if (!found)
    {
        found = CheckNextLine () ;
    }
    reportId = trim (reportId) ;
}

void fileRename (string fileName)
{
     string newFileName ;
     fstream oFile ("/home/datafile/pcldat/nextfileno", fstream::out | fstream::trunc) ;

     newFileName = pconfig -> getValue ("dataDir") ;
     newFileName += "/" + to_string (fileNo) + ".dat" ;
     rename (fileName.c_str(), newFileName.c_str()) ;
     fileNo++ ;
     oFile << to_string (fileNo) ;
     oFile.close () ;
}

void index4Main (string fileName)
{
    string newId ;

    lineLength = getLineLength (fileName) ;
    fileNo = getNextFileNo () ;
    volume = getVolume () ;
    long localOfst = 0 ;
    iFile.open (fileName, ifstream::binary) ;
    unsigned char* buf  = new unsigned char [lineLength+1];
    buf [lineLength] = 0 ;
//    cout << "fileName: " << fileName << " lineLength: " << lineLength << endl ;
    offsets.clear () ;
    firstOffset = lastOffset = 0 ;
    pages = 1 ;

    srchStart = pconfig -> getIntValue ("searchStart") ;
    srch = pconfig -> getStringVector ("searches") ;
    jump = pconfig -> getIntVector ("jump") ;
    iFile.seekg (0, iFile.beg) ;
    while ((iFile.peek () != EOF))
    {
        iFile.read ((char*) buf, lineLength) ;
        toAscii (buf, lineLength) ;
        line = string ((char*) buf) ;
        pos = line.find ("002") ;
        if (pos == 0)
        {
            getReportId () ;
            if (reportId != lastRef)
            {
                if ((lastRef != "") && (localOfst > 0))
                {
                    cout << "ref:" << lastRef << " firstOffset: " << firstOffset << " lastOffset: " << lastOffset << endl ;
                    doSql () ;
                    lastRef = reportId ;
                    offsets.clear () ;
                    pages = 1 ;
                }
                else
                {
                    lastRef = reportId ;
                }
                firstOffset = iFile.tellg () - lineLength ;
                offsets.push_back (firstOffset) ;
            }
            else
            {
                lastOffset = iFile.tellg () - lineLength ;
                pages++ ;
                offsets.push_back (lastOffset) ;
            }
        }
        offset += lineLength ;
        localOfst += lineLength ;
    }
//    cout << "Last one ref:" << lastRef << " firstOffset: " << firstOffset << " lastOffset: " << lastOffset << endl ;
    doSql () ;
    iFile.close () ;
    fileRename (fileName) ;
}

void getSpecialRef (string fileName)
{
    reportId = fileName ;
    size_t pos ;
    while ((pos = reportId.find ("/")) != string::npos)
    {
        reportId.erase (0, pos+1) ;
    }
    if ((pos = reportId.find (".")) != string::npos)
        reportId.erase (pos) ;
}

void index4Special (string fileName)
{
    string newId ;
    int lines = 0 ;

    lineLength = getLineLength (fileName) ;
    fileNo = getNextFileNo () ;
    volume = getVolume () ;
    iFile.open (fileName, ifstream::binary) ;
    unsigned char* buf  = new unsigned char [lineLength+1];
    buf [lineLength] = 0 ;
    pages = 0 ;

//    cout << "fileName: " << fileName << " lineLength: " << lineLength << endl ;


    srchStart = pconfig -> getIntValue ("searchStart") ;
    srch = pconfig -> getStringVector ("searches") ;
    jump = pconfig -> getIntVector ("jump") ;
    iFile.seekg (0, iFile.beg) ;
    getSpecialRef (fileName) ;

    offsets.clear () ;
    offsets.push_back (0) ;
    firstOffset = 0 ;

    while ((iFile.peek () != EOF))
    {

        iFile.read ((char*) buf, lineLength) ;
        toAscii (buf, lineLength) ;
        line = string ((char*) buf) ;
        pos = line.find ("002") ;
        if (pos == 0)
        {
            lastOffset = iFile.tellg () - lineLength ;
            if (lines > 0)
            {
                pages++ ;
                offsets.push_back (lastOffset) ;
            }
        }
        lines ++ ;
    }
    lastRef = reportId ;
    cout << "ref:" << lastRef << " firstOffset: " << firstOffset << " lastOffset: " << lastOffset << endl ;
    doSql () ;
    iFile.close () ;
    fileRename (fileName) ;

}

void index (string fileName)
{
    int leaderLength ;
    leaderLength = pconfig -> getIntValue ("leaderLength") ;
    cout << "fileName: " << fileName << endl ;

    switch (leaderLength)
    {

        case 4:
            if (fileName.find ("download.136") != string::npos)
                index4Main (fileName) ;
            else
                index4Special (fileName) ;

        break;
        default:
        break ;
    }

}

void writeHeader (string sysId, string date)
{
    string sql = "INSERT INTO df_mainindex_def (systemid, indexdate) VALUES (" ;
    sql += "'" + sysId + "','" + date + "') ;" ;
    pTDatabase -> ExecSql (sql) ;
}

int main (int argc, char** argv)
{
    vector <string> srch ;
    vector <string> filesToIndex ;
    string dataDir ;

    try
    {
        if (argc != 3)
        {
            throw (string ("Usage index <systemid> <date (format yyyymmdd)>")) ;
        }
        sysName = string (argv [1]) ;
        indexDate = argv [2] ;

        pconfig = new config (sysName) ;
        pTDatabase = new TDatabase ("/home/datafile/pcldat/secfile") ;

        cout << "dataDir: " << pconfig -> getValue ("dataDir") << endl ;
        cout << "indexDir: " << pconfig -> getValue ("indexDir") << endl ;
        cout << "leaderLength: " << pconfig -> getIntValue ("leaderLength") << endl ;
        cout << "searchStart: " << pconfig -> getIntValue ("searchStart") << endl ;
        cout << "mrlLen: " << pconfig -> getIntValue ("mrlLen") << endl ;

        srch = pconfig -> getStringVector ("searches") ;

        for (auto i = srch.begin(); i != srch.end(); ++i)
            cout << *i << " " << endl ;

        dataDir = pconfig -> getValue ("dataDir") ;
        filesToIndex = getIndexableFiles (dataDir) ;
        if (filesToIndex.size())
        {
            writeHeader (sysName, indexDate) ;
            for (auto i = filesToIndex.begin(); i != filesToIndex.end(); ++i)
                index (dataDir + "/" + *i) ;
        }
        else
        {
            cout << endl << "Nothing to do! Check download?" << endl ;
        }
        delete pTDatabase ;
        delete pconfig ;
    }
    catch (string err)
    {
        cout << err << endl ;
        exit (-1) ;
    }
    exit (0) ;
}
